import { Component, OnInit, Injectable, Renderer2 } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { Response } from '@angular/http';

import { SideNavigationService } from '../../services/side-navigation-service';
import { ConceptServices } from '../../services/concept-services';
import { SystemServices } from '../../services/system-services';
import {
  FETCH_CONCEPTS,
  FETCHING_CONCEPTS,
  CLEAR_CONCEPTS,
  INITIALIZE_CONCEPT_SEARCH_META_DATA,
  SEARCH_ICON_FOCUSED,
  RESET_CONCEPT_SEARCH_BUTTONS,
  FOCUS_ON,
} from '../../actions';
import { IAppState } from '../../store';

@Component({
  selector: 'app-concept-search',
  templateUrl: './concept-search.component.html',
  styleUrls: ['./concept-search.component.scss'],
})
@Injectable()
export class ConceptSearchComponent implements OnInit {
  query='';
  errorMessage = '';
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private snService: SideNavigationService,
    private conceptServices: ConceptServices,
    private systemServices: SystemServices,
    private renderer: Renderer2) {
  }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  getResultsUsefulMessageContent() {
    const conceptSearchData = this.getState().conceptSearch.conceptSearchData;
    const startingIndex = conceptSearchData.baselineSurveyIndex;
    if (startingIndex < 1 || startingIndex === undefined || startingIndex === null) {
      return 'Sadly, none of these can be used in a cohort definition...';
    } else {
      return `The first ${startingIndex} result(s) can be used in a cohort definition!`;
    }
  }

  hasUsefulContent() {
    const conceptSearchData = this.getState().conceptSearch.conceptSearchData;
    const startingIndex = conceptSearchData.baselineSurveyIndex;
    return !(startingIndex === '0' || startingIndex === 0 || startingIndex === undefined || startingIndex === null);
  }

  getResultsMessageContent() {
    const conceptSearchData = this.getState().conceptSearch.conceptSearchData;
    const startResultsCount = conceptSearchData.start;
    let endResultCount = conceptSearchData.start + 20;
    const totalResultCount = conceptSearchData.numFound;
    if (endResultCount > totalResultCount) {
      endResultCount = totalResultCount;
    }
    return `${startResultsCount}-${endResultCount} out of ${totalResultCount} results`
  }

  conceptExists() {
    return this.getState().conceptSearch.concepts.length > 0
  }

  disableActive() {
    this.snService.disableActiveIcon('conceptSearchIcon');
  }

  hasErrorMessages() {
    return this.errorMessage.length > 0;
  }

  fetchConcepts() {//(form) {
    this.ngRedux.dispatch({
      type: CLEAR_CONCEPTS,
    });
    // clear messages
    this.errorMessage = '';
    if (this.query.length > 0) {
      this.ngRedux.dispatch({
        type: FETCHING_CONCEPTS
      });
      this.conceptServices
      .fetchConcepts(this.query)
      .subscribe(
        (response: Response) => {
        if (response.status === 200) {
          let rdata = JSON.parse(response.text());
          this.ngRedux.dispatch({
            type: FETCH_CONCEPTS,
            payload: rdata.response.response.docs
          });
          // here I need to do something for initializing pagination data
          // I get back numFound and start - both are integers
          const numPages = Math.ceil(rdata.response.response.numFound / 20);
          const pageObjects = this.conceptServices.getPageObjects(numPages);
          const currentPageObjects = this.conceptServices.getCurrentPageObjects(pageObjects, 0);
          this.ngRedux.dispatch({
            type: INITIALIZE_CONCEPT_SEARCH_META_DATA,
            payload: {
              baselineSurveyIndex: rdata.response.response.baselineSurveyIndex,
              queryString: this.query,
              numFound: rdata.response.response.numFound,
              start: rdata.response.response.start,
              numPages: numPages,
              currentPageNum: 1,
              pageObjects: pageObjects,
              currentPageObjects: currentPageObjects
            }
          });
          this.ngRedux.dispatch({
            type: RESET_CONCEPT_SEARCH_BUTTONS
          });
          // setTimeout(()=> {
            this.systemServices.focusOn('conceptSearchResultMessage');
          // }, 1000);
          this.query = '';
        }
      }); 
    } else {
      let message = ''
      if (this.query.length < 1) {
        message += 'Input can\'t be empty.';
      }
      // if (!form.valid) {
      //   message += 'No special characters allowed.';
      // }
      this.errorMessage = message;
      if (this.hasErrorMessages()) {
        this.systemServices.focusOn('searchInputErrorMessage');
      }
    }
  }
}
